//
//  MCBulkEditWindow.h
//  MCApplication
//
//  Created by Eric Hochmeister on 10/2/06.
//  Copyright 2006 __MyCompanyName__. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import "MCWindowController.h"

@interface MCBulkEditWindow : MCWindowController {

    NSDictionary* cachedValues;
    NSMutableDictionary* keyPathValues;
    NSArray* keyPaths;
    NSArray* objects;
}

- (void)setupWithObjects:(NSArray*)objs keyPaths:(NSArray*)keyPaths;

- (NSDictionary*)cachedValues;
- (void)setCachedValues:(NSDictionary*)valuesDict;

- (NSMutableDictionary*)keyPathValues;
- (void)setKeyPathValues:(NSMutableDictionary*)valuesDict;

- (NSArray*)keyPaths;
- (void)setKeyPaths:(NSArray*)kps;

- (NSArray*)objects;
- (void)setObjects:(NSArray*)objs;

- (NSDictionary*)findCommonValues;

- (IBAction)ok:(id)sender;
- (IBAction)cancel:(id)sender;

- (void)resolveChanges;

- (void)setDefaultValue:(id)aValue forKeyIfNotPresent:(NSString*)aKey didChange:(BOOL)flag;

- (NSArray*)keysWhichDidChange:(NSArray*)theKeys;
- (NSString*)deriveKeyFromDidChangeKey:(NSString*)didChangeKey;

@end
